<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Review extends Model 
{

    protected $table = 'reviews';
    public $timestamps = true;
    protected $fillable = array('booking_id', 'doctor_id', 'patient_id', 'doctor_satisfaction', 'patient_satisfaction');

    public function patientId()
    {
        return $this->hasOne('App\Models\User', 'patient_id');
    }

    public function doctorInfo()
    {
        return $this->hasOne('App\Models\User', 'doctor_id');
    }

    public function bookings()
    {
        return $this->hasOne('App\Models\BookingInfo', 'booking_id');
    }

}